/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.util.BlockBounds;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class SafeChunkBounds {
    public static final SafeChunkBounds ANY = new SafeChunkBounds(){

        @Override
        public boolean inBounds(BlockPos pos, boolean gap) {
            return true;
        }
    };
    protected static final Tile[] tiles = new Tile[16];
    private final ChunkPos center;
    private final BlockBounds[] chunkBounds = new BlockBounds[16];

    protected SafeChunkBounds() {
        this.center = null;
    }

    public SafeChunkBounds(World world, ChunkPos pos) {
        this.center = pos;
        for (Tile t : tiles) {
            ChunkPos cp = new ChunkPos(pos.field_77276_a + t.pos.field_77276_a, pos.field_77275_b + t.pos.field_77275_b);
            Chunk c = world.func_72863_F().func_186026_b(cp.field_77276_a, cp.field_77275_b);
            this.chunkBounds[t.index] = c != null ? new BlockBounds(cp) : BlockBounds.INVALID;
        }
        for (Tile t : tiles) {
            BlockBounds curr = this.chunkBounds[t.index];
            if (curr == BlockBounds.INVALID) continue;
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                boolean validDir = false;
                if ((t.borders & 1 << dir.func_176745_a()) != 0) {
                    BlockBounds adjTile = this.chunkBounds[t.index + dir.func_82601_c() + dir.func_82599_e() * 4];
                    boolean bl = validDir = adjTile != BlockBounds.INVALID;
                }
                if (validDir) continue;
                curr.shrink(dir, 1);
            }
        }
    }

    public boolean inBounds(BlockPos pos, boolean gap) {
        int chunkZ;
        int tileZ;
        int chunkX = pos.func_177958_n() >> 4;
        int tileX = chunkX - this.center.field_77276_a + 1;
        if (((tileX | (tileZ = (chunkZ = pos.func_177952_p() >> 4) - this.center.field_77275_b + 1)) & 0xFFFFFFFC) == 0) {
            int index = tileX + tileZ * 4;
            return !gap && this.chunkBounds[index] != BlockBounds.INVALID || this.chunkBounds[index].inBounds(pos);
        }
        return false;
    }

    public boolean inBounds(BlockBounds bounds, boolean gap) {
        BlockPos min = bounds.getMin();
        BlockPos max = bounds.getMax();
        return this.inBounds(min, gap) && this.inBounds(max, gap) && this.inBounds(new BlockPos(min.func_177958_n(), 0, max.func_177952_p()), gap) && this.inBounds(new BlockPos(max.func_177958_n(), 0, min.func_177952_p()), gap);
    }

    public void setBlockState(World world, BlockPos pos, IBlockState state, boolean gap) {
        this.setBlockState(world, pos, state, 3, gap);
    }

    public void setBlockState(World world, BlockPos pos, IBlockState state, int flags, boolean gap) {
        if (this.inBounds(pos, gap)) {
            world.func_180501_a(pos, state, flags);
        }
    }

    static {
        for (int z = 0; z < 4; ++z) {
            for (int x = 0; x < 4; ++x) {
                int index = z * 4 + x;
                SafeChunkBounds.tiles[index] = new Tile(index, new ChunkPos(x - 1, z - 1), (z != 0 ? 4 : 0) | (z != 3 ? 8 : 0) | (x != 0 ? 16 : 0) | (x != 3 ? 32 : 0));
            }
        }
    }

    protected static class Tile {
        public final ChunkPos pos;
        public final int borders;
        public final int index;

        public Tile(int index, ChunkPos pos, int borderFlags) {
            this.index = index;
            this.pos = pos;
            this.borders = borderFlags;
        }
    }
}

